import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/view/components/text/label_text.dart';

class CustomAmountTextField extends StatefulWidget {
  const CustomAmountTextField({Key? key, required this.labelText, required this.hintText, this.controller, this.chargeText = '', required this.currency, required this.onChanged, this.autoFocus = false, this.inputAction, this.readOnly = false, this.needLabelText = false, this.enableBorder = false}) : super(key: key);

  final String chargeText;
  final String labelText;
  final String hintText;
  final String currency;
  final bool autoFocus;
  final bool readOnly;
  final bool needLabelText;
  final Function(String) onChanged;
  final TextEditingController? controller;
  final TextInputAction? inputAction;
  final bool enableBorder;

  @override
  State<CustomAmountTextField> createState() => _CustomAmountTextFieldState();
}

class _CustomAmountTextFieldState extends State<CustomAmountTextField> {
  bool isFocus = false;
  final TextEditingController _textEditingController = TextEditingController();

  @override
  void initState() {
    super.initState();
    // Initialize the text controller with the initial value if provided
    if (widget.controller != null) {
      _textEditingController.text = widget.controller!.text;
    }
  }

  @override
  Widget build(BuildContext context) {
    return widget.needLabelText
        ? Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              LabelText(text: widget.labelText.tr),
              const SizedBox(height: 8),
              Container(
                height: 50,
                width: MediaQuery.of(context).size.width,
                padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: 8),
                decoration: BoxDecoration(color: MyColor.getTransparentColor(), border: Border.all(color: isFocus ? MyColor.getTextFieldEnableBorder() : MyColor.getTextFieldDisableBorder(), width: 0.5), borderRadius: BorderRadius.circular(Dimensions.defaultRadius)),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Expanded(
                      flex: 5,
                      child: FocusScope(
                        child: Focus(
                          onFocusChange: (focus) {
                            setState(() {
                              isFocus = focus;
                            });
                          },
                          child: TextFormField(
                            cursorColor: MyColor.colorBlack,
                            readOnly: widget.readOnly,
                            controller: widget.controller,
                            autofocus: widget.autoFocus,
                            style: regularDefault.copyWith(color: MyColor.getTextColor()),
                            //textAlign: TextAlign.left,

                            // keyboardType: TextInputType.numberWithOptions(decimal: true),

                            inputFormatters: <TextInputFormatter>[
                              FilteringTextInputFormatter.allow(RegExp(r'^\d*\.?\d{0,2}')),
                            ],
                            textInputAction: widget.inputAction,
                            onChanged: (newValue) {
                              // Trim whitespace and set the value
                              final trimmedValue = newValue.trim();
                              if (newValue != trimmedValue) {
                                _textEditingController.text = trimmedValue;
                                _textEditingController.selection = TextSelection.fromPosition(TextPosition(offset: trimmedValue.length));
                              }

                              // Call the onChanged callback with the trimmed value
                              widget.onChanged(trimmedValue);
                            },
                            // textInputAction: widget.inputAction,
                            // onChanged: widget.onChanged,
                            decoration: InputDecoration(
                                contentPadding: const EdgeInsetsDirectional.only(bottom: 16),
                                hintText: widget.hintText,
                                hintStyle: regularSmall.copyWith(color: MyColor.hintTextColor.withOpacity(0.7), height: 1.452),
                                border: InputBorder.none,
                                focusedBorder: InputBorder.none,
                                enabledBorder: InputBorder.none,
                                disabledBorder: InputBorder.none,
                                focusedErrorBorder: InputBorder.none,
                                errorBorder: InputBorder.none),
                          ),
                        ),
                      ),
                    ),
                    Container(
                      width: 48,
                      padding: const EdgeInsets.all(Dimensions.space5),
                      decoration: BoxDecoration(color: MyColor.getPrimaryColor().withOpacity(0.05), borderRadius: BorderRadius.circular(5)),
                      alignment: Alignment.center,
                      child: Text(widget.currency, textAlign: TextAlign.center, style: regularDefault.copyWith(color: MyColor.getPrimaryColor(), fontWeight: FontWeight.w500)),
                    )
                  ],
                ),
              ),
            ],
          )
        : Container(
            height: 50,
            width: MediaQuery.of(context).size.width,
            padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: 8),
            decoration: BoxDecoration(
                color: MyColor.getTransparentColor(),
                border: widget.enableBorder
                    ? Border.all(
                        color: isFocus ? MyColor.customBorderColor : MyColor.customBorderColor,
                        width: 0.5,
                      )
                    : null,
                borderRadius: BorderRadius.circular(Dimensions.defaultRadius)),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Expanded(
                  flex: 5,
                  child: FocusScope(
                    child: Focus(
                      onFocusChange: (focus) {
                        setState(() {
                          isFocus = focus;
                        });
                      },
                      child: TextFormField(
                        // enabled: widget.isDisabled,
                        cursorColor: MyColor.colorBlack,
                        readOnly: widget.readOnly,
                        controller: widget.controller,
                        autofocus: widget.autoFocus,
                        style: regularDefault.copyWith(color: MyColor.getTextColor()),
                        //textAlign: TextAlign.left,
                        keyboardType: TextInputType.number,
                        textInputAction: widget.inputAction,
                        onChanged: widget.onChanged,
                        decoration: InputDecoration(
                            contentPadding: const EdgeInsetsDirectional.only(bottom: 16), hintText: widget.hintText, hintStyle: regularSmall.copyWith(color: MyColor.hintTextColor.withOpacity(0.7), height: 1.452), border: InputBorder.none, focusedBorder: InputBorder.none, enabledBorder: InputBorder.none, disabledBorder: InputBorder.none, focusedErrorBorder: InputBorder.none, errorBorder: InputBorder.none),
                      ),
                    ),
                  ),
                ),
                Container(
                  width: 48,
                  padding: const EdgeInsets.all(Dimensions.space5),
                  decoration: BoxDecoration(color: MyColor.getPrimaryColor().withOpacity(0.05), borderRadius: BorderRadius.circular(5)),
                  alignment: Alignment.center,
                  child: Text(widget.currency, textAlign: TextAlign.center, style: regularDefault.copyWith(color: MyColor.getPrimaryColor(), fontWeight: FontWeight.w500)),
                )
              ],
            ),
          );
  }
}
